# On Non-Default SD Image File Sizing

SD image files are sized to strike a balance between the storage
required for the OS itself, the amount of free storage desired (or
required) when the image "goes live", and the bandwidth required to
move image files between workstations.

The size of the image file itself can be adjusted when the image is
constructed. Or, the size of the image's filesystem can be expanded
after the image file is written to an SD card.

## Procedure - Specifying an Image Size at Construction

The `FSSIZZEMB` envar defines the image file's final size. You can
override the default at the `mkos` command line:

   > user@workstation:$ **FSSIZEMB=4096 mkos-akna**

# Resizing a Deployed Image

Advanced users will prefer the following alternative procedure in some
cases:

1. Build SD image files using the smallest FSSIZEMB possible; then,
1. Resize the image after writing the SD card.

Using the smallest-possible FSSIZEMB accelerates both image-generation
and distribution activities. Resizing the image's filesystem *after*
writing the image to an SD card allows the runtime free storage to be
adjusted depending upon the size of the SD card in use.

The resizing step requires the `fdisk` and `resize2fs` tools, and can
be performed at the user's workstation or on a live filesystem (a
reboot is usually required in the latter case).

(Note: `sfdisk` can be used in place of fdisk, but the details are
beyond the scope of this document.)

## Procedure - Resizing an Installed Filesystem

First, resize the partition containing the image's filesystem.

Assuming your SD card is attached at **/dev/sdb**, delete and then
re-create the filesystem partition *beginning at the same starting
sector*. The end sector must be equal to or greater than the original
location:

   > user@workstation:~$ **sudo fdisk /dev/sdb**  
   > Welcome to fdisk (util-linux 2.33.1).  
   > Command (m for help): **p**  
   > Disk /dev/sdb: 29.7 GiB, 31914983424 bytes, 62333952 sectors  
   > Device     Boot Start     End Sectors Size Id Type  
   > /dev/sdb1  \*     ***4096*** 4194303 4190208   2G 83 Linux  
   >
   > Command (m for help): **d**  
   > Selected partition 1  
   > Partition 1 has been deleted.  
   >
   > Command (m for help): **n**  
   > Partition type  
   > Select (default p): **p**  
   > Partition number (1-4, default 1): **1**  
   > First sector (2048-62333951, default 2048): **4096**  
   > Last sector, +/-sectors or +/-size{K,M,G,T,P} (4096-62333951, default 62333951): **62333951**  
   > Created a new partition 1 of type 'Linux' and of size 29.7 GiB.  
   >
   > Partition #1 contains a ext4 signature.  
   > Do you want to remove the signature? [Y]es/[N]o: **n**  
   >
   > Command (m for help): **w**  
   > The partition table has been altered.  
   > Calling ioctl() to re-read partition table.  
   > Syncing disks.  

Second, resize the filesystem so that it fills the whole partition:

   > user@workstation:~$ **sudo resize2fs /dev/sdb1**  
   > resize2fs 1.44.5 (15-Dec-2018)  
   > Resizing the filesystem on /dev/sdb1 to 7791232 (4k) blocks.  
   > The filesystem on /dev/sdb1 is now 7791232 (4k) blocks long.

You may now use the SD card as usual.
