# Bootstrapping a Pragmatux SDK

The following describes how to create a **Pragmatux SDK for Akna**
environment starting with only a pristine Debian workstation and the
SDK source code.

Note: This document, and the whole procedure it describes, is a work
in progress. In particular, there are ways to make APT help us with
installing of various build-dependencies and install-dependencies
along the way. Pbuilder and sbuild can also automate much of this
process.


## Overall SDK Package Summary

Here is the list of SDK packages that were manually built in order to
bootstrap the Akna SDK from sources during the production of this
document. The combination of these packages, plus access to an
upstream Debian Buster repository, is enough to permit installation of
the Akna SDK on a pristine Debian Buster workstation:

   > bgat@bustervm-pristine:~/akna$ **find . -name "\*.deb" | grep -v dbgsym**  
   > ./usafirmware-sdk-akna/debian/build/mkos-akna_47~g54d4686_all.deb  
   > ./usafirmware-sdk-akna/debian/build/sdk-akna_47~g54d4686_all.deb  
   > ./usafirmware-sdk-pru/debian/build/sdk-pru_12~g48a9c1c_all.deb  
   > ./usafirmware-default-root-sshkey/debian/build/default-root-sshkey-host_10~ge8b10e5_all.deb  
   > ./mkos/debian/build/mkos_0+T1654816782~ga0982db_amd64.deb  
   > ./mkos/debian/build/mkisoarchive_0+T1654816782~ga0982db_amd64.deb  
   > ./usafirmware-ti-pru-cgt-installer/debian/build/ti-pru-cgt-installer-2.3.3_1~gf640dbe_amd64.deb  
   > ./ptux-sdk/debian/build/ptux-sdk_10ptux1~g7623280_all.deb  
   > ./ptux-sdk/debian/build/ptux-sdk-armhf_10ptux1~g7623280_all.deb  
   > ./mkos-mlo-common/debian/build/mkos-mlo-foreign_31ptux1~g7f8910c_all.deb  
   > ./mkos-mlo-common/debian/build/mkos-mlo-common_31ptux1~g7f8910c_all.deb  
   > ./usafirmware-ti-pru-software-support/debian/build/ti-pru-software-support-package-6.0.1_1~gac934d5_all.deb


## Source repositories

* git@gitlab.com:pragmatux/devscripts-ptux.git
* git@gitlab.com:pragmatux/mkos-mlo-common.git
* git@github.com:blfsinc/usafirmware-ti-pru-cgt-installer.git
* git@github.com:blfsinc/usafirmware-ti-pru-software-support.git
* git@gitlab.com:pragmatux/mkos.git
* git@github.com:blfsinc/usafirmware-default-root-sshkey.git
* git@gitlab.com:pragmatux/ptux-sdk.git
* git@github.com:blfsinc/usafirmware-sdk-akna.git


## On package build-time dependencies

Use the `dpkg-buildpackage -D` command to confirm that a package's
build-dependencies are all met. For example:

   > user@workstation:devscripts-ptux$ **dpkg-buildpackage -D**  
   > dpkg-buildpackage: info: source package devscripts-ptux  
   > dpkg-buildpackage: info: source version 0+T1388276554~gd114764  
   > dpkg-buildpackage: info: source distribution UNRELEASED  
   > dpkg-buildpackage: info: source changed by Ryan Kuester <rkuester@insymbols.com>  
   > dpkg-buildpackage: info: host architecture amd64  
   >  dpkg-source --before-build .  
   > dpkg-checkbuilddeps: error: Unmet build dependencies: dh-python python-setuptools git-buildpackage python-debian python-docopt  
   > dpkg-buildpackage: warning: build dependencies/conflicts unsatisfied; aborting  
   > dpkg-buildpackage: warning: (Use -d flag to override.)
 

The above output confirms that the **dh-python**, **python-setuptools**,
**git-buildpackage**, **python-debian**, and **python-docopt** packages must be
installed before the **devscripts-ptux** package can be built.


# Procedure

In each of the following sections, I show the commands required to
build each package from source. I also include commands required to
install each package on the bootstrapping workstation, for situations
where the goal is to both bootstrap the SDK packages themselves AND
create an SDK-capable workstation.

In situations where JUST bootstraping of the SDK packages themselves
is required, i.e. building packages for populating an empty package
repository that will later be used to commission developer
workstations, the bootstrapping workstation needs only the
**devscripts-ptux** package.


## Add the *armhf* architecture

This permits dpkg to install armhf-architecture packages when
necessary. This step is required only for workstations that want to
run the SDK itself.

   > user@workstation:~/$ **sudo dpkg --add-architecture armhf**  
   > user@workstation:~/$ **sudo apt update**


## devscripts-ptux

This package contains various helper scripts that automate common build activities.

   > user@workstation:~/devscripts-ptux$ **git checkout master**  
   > user@workstation:~/devscripts-ptux$ **dpkg-buildpackage -us -uc -b**  
   > user@workstation:~/devscripts-ptux$ **sudo dpkg --install ../devscripts-ptux\*deb ../ptuxrepo\*deb**  
   > dpkg: dependency problems prevent configuration of ptuxrepo:  
   >   ptuxrepo depends on python3-yaml; however:  
   >   Package python3-yaml is not installed.  
   > user@workstation:~/devscripts-ptux$ **sudo apt install python3-yaml**  
   > Unpacking python3-yaml (3.13-2) ...  
   > Setting up python3-yaml (3.13-2) ...  
   > Setting up ptuxrepo (0+T1388276554~gd114764) ...  
   > Setting up devscripts-ptux (0+T1388276554~gd114764) ...  


## usafirmware-default-root-sshkey

This package provides a default SSH root login key for Akna devices.

   > user@workstation:~/usafirmware-default-root-sshkey$ **ptuxbuild**  
   > user@workstation:~/usafirmware-default-root-sshkey$ **sudo dpkg --install debian/build/default-root-sshkey-host\*deb**


## mkos-mlo-common

This package contains the MLO-specific parts of the mkos tool.

   > user@workstation:~/mkos-mlo-common$ **git checkout master**  
   > user@workstation:~/mkos-mlo-common$ **ptuxbuild**  
   > user@workstation:~/mkos-mlo-common$ **sudo apt install libguestfs-tools**  
   > user@workstation:~/mkos-mlo-common$ **sudo dpkg --install debian/build/mkos-mlo-common\*deb**  
   > user@workstation:~/mkos-mlo-common$ **sudo dpkg --install debian/build/mkos-mlo-foreign\*deb**  


## usafirmware-ti-pru-cgt-installer

This package provides TI's Code Generation Tools (CGT) for the PRU.

   > user@workstation:~/usafirmware-ti-pru-cgt-installer$ **git checkout main**  
   > user@workstation:~/usafirmware-ti-pru-cgt-installer$ **ptuxbuild**  
   > user@workstation:~/usafirmware-ti-pru-cgt-installer$ **sudo dpkg --install debian/build/\*deb**


## usafirmware-ti-pru-software-support

This package includes supporting header files and libraries for PRU development.

   > user@workstation:~/usafirmware-ti-pru-software-support$ **git checkout main**  
   > user@workstation:~/usafirmware-ti-pru-software-support$ **ptuxbuild**  
   > user@workstation:~/usafirmware-ti-pru-software-support$ **sudo dpkg --install debian/build/\*deb**


## usafirmware-sdk-pru

This package brings in the TI PRU packages.

   > user@workstation:~/usafirmware-sdk-pru$ **git checkout main**  
   > user@workstation:~/usafirmware-sdk-pru$ **ptuxbuild**  
   > user@workstation:~/usafirmware-sdk-pru$ **sudo dpkg --install debian/build/\*deb**


## mkos

This package provides legacy functions needed by some packages.

   > user@workstation:~/mkos$ **sudo apt install meson libboost-filesystem-dev libboost-system-dev libboost-dev libdocopt-dev reprepro kpartx efibootmgr**  
   > user@workstation:~/mkos$ **ptuxbuild**  
   > user@workstation:~/mkos$ **sudo dpkg --install debian/build/\*deb**
   

## ptux-sdk

This package includes generic cross-compilers, etc. for ARMHF targets.

   > user@workstation:~/ptux-sdk$ **git checkout buster**  
   > user@workstation:~/ptux-sdk$ **ptuxbuild**
   > user@workstation:~/ptux-sdk$ **sudo apt install pkg-config dput-ng python3-paramiko**  
   > user@workstation:~/ptux-sdk$ **sudo dpkg --install debian/build/ptux-sdk_\*deb**
   > user@workstation:~/ptux-sdk$ **sudo apt install gcc-arm-linux-gnueabihf g++-arm-linux-gnueabihf**
   > user@workstation:~/ptux-sdk$ **sudo dpkg --install debian/build/ptux-sdk-armhf_\*deb**


## usafirmware-sdk-akna

This package brings in the cross-compilers and other tools required to build Akna applications.

   > user@workstation:~/usafirmware-sdk-akna$ **git checkout main**  
   > user@workstation:~/usafirmware-sdk-akna$ **ptuxbuild**  
   > user@workstation:~/usafirmware-sdk-akna$ **sudo dpkg --install debian/build/mkos-akna_\*deb**
   > user@workstation:~/usafirmware-sdk-akna$ **sudo apt install gdb-multiarch qt5-default qtcreator qtbase5-examples qtbase5-examples:armhf qt5-default:armhf**
   > user@workstation:~/usafirmware-sdk-akna$ **sudo dpkg --install debian/build/sdk-akna_\*deb**


