# Global Cooling Quick Start Guide

To build the firmware and root file system for the Global Cooling BBB, perform the following steps in a Debian Buster workstation after the SDK has been installed:

1. mkdir ~/akna
2. cd ~/akna
3. mkos-akna

That will grind awhile, then produce the following:

* `mkos-akna.img`  - SD card image
* `mkos-akna.fs`   - copy of the directory structure on the SD image
* `mkos-akna.iso`  - repository containing the packages that went into the image, in ISO format
* `mkos-akna.repo` - directory containing a reprepro database of the packages on the SD image

Once the build is complete, insert a micro SD card, and assuming it is /dev/sdb, issue the following command:

sudo dd if=mkos-akna.img of=/dev/sdb bs=1M conv=fsync

1. Insert the micro SD card in the BBB, press and hold the boot select button on the top side near the micro SD card, and apply power
2. The BBB will churn for a while.
3. The default login for the console is User: root   Password: password

If you want to build a fresh copy of the SD card image:

1. cd ~/akna
2. rm -rf mkos-akna.fs
3. rm mkos-akna.img
4. mkos-akna

If you want to add your own packages to the SD card image:

1. cd ~/akna
2. rm -rf mkos-akna.fs
3. rm mkos-akna.img
4. Edit mkos-akna.mstrap. Add your packages to the "packages=" line.
5. Save the file to mkos-akna.mstrap.mine, or some filename other than mkos-akna.mstrap
6. mkos-akna -i mkos-akna.mstrap.mine (or whatever filename you saved the file to in step 5)



