# akna-updaterd

Services and scripts to implement Akna's package update mechanisms.

## Theory of Operation

The `akna-updaterd.service` unit runs whenever the contents of `/media/usb[01]`
and/or `/var/www/akna/update` are changed, i.e. when an updater image or
package file becomes accessible.

A *package file* is an ordinary Debian `.deb` file. An *updater image* is an
ISO9660 image file containing an APT repository.

The `akna-updater` script examines the incoming file, and passes it one of the
following helpers based on the file type:
* `akna-updater-helper`, for deb files;
* `akna-updater-apthelper`, for ISO9660 images.

The `akna-updater-helper` script installs the deb using `dpkg`, running
inside of a transient systemd service. We use `systemd-run` so that the helper
script itself can be subject to an ordinary package upgrade.

The `akna-updater-apthelper` script runs `apt dist-upgrade -y` inside of a
transient systemd service.

After the helper script exits, the associated file is deleted. Unrecognized
file types are deleted without further action.

## Build Instructions

```console
user@workstation:~/akna-updater$ git clean -dxf
user@workstation:~/akna-updater$ ptuxbuild
```

The build products are placed in `debian/build/`.



