# sdk-akna

This source package defines the software development kit (SDK) for Akna targets.

## sdk-akna

The `sdk-akna` metapackage lists all of the workstation tools required
to build applications for Akna targets. This list is carefully
maintained, so that it is compatible with all recent `device-akna`
binary package versions.

**At present, only Debian Buster workstation environments are
supported. Virtual machines and chroots are known to work, in
addition to native installations.**

### Installation

Add the location of the Akna SDK package repository to your
workstation's APT `sources.list.d` list. In most cases, this is
accomplished by installing the `apt-source-akna-sdk` package provided
by your development team leader.

Next, add **armhf** to your workstation package manager's supported
architectures. This will allow your workstation's package manager to
install cross-platform development libraries:

```bash
user@workstation:~$ sudo dpkg --add-architecture armhf
user@workstation:~$ sudo apt update
```

Finally, install the `sdk-akna` package:

```bash
user@workstation:~$ sudo apt install sdk-akna
```

The result is a workstation with development tools required for
building Akna applications, and for composing filesystem images.


## mkos-akna

The `mkos-akna` package contains tools for composing SD filesystem images for Akna:

* `mkos-akna-base` - "base" filesystem, i.e. console-only
* `mkos-akna-base-installer` - "base" filesystem plus eMMC self-installer
* `mkos-akna` - full filesystem, including GUI
* `mkos-akna-installer` - full filesystem plus eMMC self-installer

The `mkos-akna` package is included in the Akna SDK.

The eMMC self-installers transfer the SD image into Akna's onboard
eMMC storage device, then shut down the system (to provide visual
indication that the operation is complete). The system can then be
restarted without an SD card installed.

### Creating filesystem images

Choose one of the `mkos-akna*` scripts depending on your
objective. All four scripts work in the same way, without additional
parameters, i.e.:

```bash
user@workstation:~$ mkos-akna-base-installer
```

The output of interest is the SD image file, which ends in **.img**:

```bash
user@workstation:~$ ls
mkos-akna.fs   mkos-akna.iso       mkos-akna.mstrap
mkos-akna.img  mkos-akna.manifest  mkos-akna.repo
```

Note: The `mkos-akna*` scripts require that that the hostname
**globalcooling** be resolveable.

### Writing filesystem images to SD

A command like the following will write an image file to an SD card:

```bash
user@workstation:~$ sudo dd if=mkos-akna.img of=/dev/sdQ bs=1M conv=fsync
```

Note: Replace **/dev/sdQ** with your SD card's block device name.

### Adjusting mkos's behavior

The `mkos-akna*` tools all use `multistrap(1)` to compose the
filesystem. The multistrap configuration file is stored under
`/usr/share/mkos-akna`, and is also written to the working directory
when composition is performed.

To change `mkos-akna`'s behavior, rename and then edit the **.mstrap**
file in your working directory, and then feed it to `mkos-akna*`
instead of the default:

```bash
user@workstation:$ CFG=my-config.mstrap mkos-akna-base-installer
```

