/*
 * Copyright (c) 2014-2015 Texas Instruments Incorporated
 *
 * s_copysignf.c -- float version of s_copysign.c.
 * Conversion to float by Ian Lance Taylor, Cygnus Support, ian@cygnus.com.
 */

/*
 * ====================================================
 * Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
 *
 * Developed at SunPro, a Sun Microsystems, Inc. business.
 * Permission to use, copy, modify, and distribute this
 * software is freely granted, provided that this notice
 * is preserved.
 * ====================================================
 */


/*
 * copysignf(float x, float y)
 * copysignf(x,y) returns a value with the magnitude of x and
 * with the sign bit of y.
 */

#include <stdint.h>
#include "math.h"
#include "math_private.h"

float
copysignf(float x, float y)
{
	uint32_t ix,iy;
	GET_FLOAT_WORD(ix,x);
	GET_FLOAT_WORD(iy,y);
	SET_FLOAT_WORD(x,(ix&0x7fffffff)|(iy&0x80000000));
        return x;
}

#if DBL_MANT_DIG == FLT_MANT_DIG
double copysign(double x, double y) __attribute__((__alias__("copysignf")));
#endif

#if LDBL_MANT_DIG == FLT_MANT_DIG
long double copysignl(long double x, long double y) __attribute__((__alias__("copysignf")));
#endif
