/*
 * Copyright (c) 2014-2015 Texas Instruments Incorporated
 *
 * ====================================================
 * Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
 *
 * Developed at SunPro, a Sun Microsystems, Inc. business.
 * Permission to use, copy, modify, and distribute this
 * software is freely granted, provided that this notice
 * is preserved.
 * ====================================================
 */


/*
 * copysign(double x, double y)
 * copysign(x,y) returns a value with the magnitude of x and
 * with the sign bit of y.
 */

#include <stdint.h>
#include "math.h"
#include "math_private.h"

__ieee64_t
F(copysign)(__ieee64_t x, __ieee64_t y)
{
	uint32_t hx,hy;
	GET_HIGH_WORD(hx,x);
	GET_HIGH_WORD(hy,y);
	SET_HIGH_WORD(x,(hx&0x7fffffff)|(hy&0x80000000));
        return x;
}

#if LDBL_MANT_DIG == DBL_MANT_DIG
long double copysignl(long double x, long double y) __attribute__((__alias__("copysign")));
#endif
