/****************************************************************************/
/*  cvtfd.c                                                                 */
/*                                                                          */
/* Copyright (c) 1997 Texas Instruments Incorporated                        */
/* http://www.ti.com/                                                       */
/*                                                                          */
/*  Redistribution and  use in source  and binary forms, with  or without   */
/*  modification,  are permitted provided  that the  following conditions   */
/*  are met:                                                                */
/*                                                                          */
/*     Redistributions  of source  code must  retain the  above copyright   */
/*     notice, this list of conditions and the following disclaimer.        */
/*                                                                          */
/*     Redistributions in binary form  must reproduce the above copyright   */
/*     notice, this  list of conditions  and the following  disclaimer in   */
/*     the  documentation  and/or   other  materials  provided  with  the   */
/*     distribution.                                                        */
/*                                                                          */
/*     Neither the  name of Texas Instruments Incorporated  nor the names   */
/*     of its  contributors may  be used to  endorse or  promote products   */
/*     derived  from   this  software  without   specific  prior  written   */
/*     permission.                                                          */
/*                                                                          */
/*  THIS SOFTWARE  IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS   */
/*  "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT   */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR   */
/*  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT   */
/*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,   */
/*  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL  DAMAGES  (INCLUDING, BUT  NOT   */
/*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,   */
/*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY   */
/*  THEORY OF  LIABILITY, WHETHER IN CONTRACT, STRICT  LIABILITY, OR TORT   */
/*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE   */
/*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.    */
/*                                                                          */
/****************************************************************************/

#include "double_config.h"
#include "reald.h"


#if (BPdouble > BPfloat)
#define LEAN float
#define BPLEAN BPfloat
#include "ieeemask.h"

#include "renormd.h"
/*#include "frcaddd.h"*/
#include "frcmpyd.h"
#include "frcdivd.h"

_CODE_ACCESS double _cvtfd(float x)
/*---------------------------------------------------------------------------*/
/* Grow LEAN to REAL.                                                        */
#ifdef Support_INFNAN
/* Handles +/- INFINITY, NAN.                                                */
#else
/* Does *NOT* handle +/- INFINITY, NAN.                                      */
#endif
#ifdef Support_DENORM
/* Handles denormalized numbers.                                             */
#else
/* Does *NOT* handle denormalized numbers.                                   */
#endif
/*---------------------------------------------------------------------------*/
{
#if IEEE_Hardware
   return (REAL)x;
#else
#if (BPREAL == 2*BPbigint) && (BPLEAN == BPbigint)
   int exp;
   bigint frc;
   CREAL rslt;

   /* Unpack fraction and exponent, ignoring the sign for now. */
   LEANasINT(frc,x); frc &= ~MINUS;
   if (exp = (int)(frc >> LEAN_FRC_MSBs)) {
      /* normals, INF and NaN are just re-justified and re-biased */
      rslt.u.lsh = frc << BPbigint+REAL_FRC_MSBs-LEAN_FRC_MSBs;

      rslt.u.msh = (frc >> LEAN_FRC_MSBs-REAL_FRC_MSBs) +

                   /* adjust exponent bias */
                   ((exp == LEAN_EXP_INFNAN) ?
                    (bigint)REAL_EXP_INFNAN-LEAN_EXP_INFNAN << REAL_FRC_MSBs:
                    (bigint)REAL_EXP_BIAS  -LEAN_EXP_BIAS   << REAL_FRC_MSBs);
   }
#ifdef Support_DENORM
   else if (frc) {
      /* all denormals become normalized, except 0 */
      while ((frc <<= 1) < LEAN_HIDDEN_BIT) exp -= 1;
        rslt.u.lsh = frc << BPbigint+REAL_FRC_MSBs-LEAN_FRC_MSBs;
	rslt.u.msh = (frc >> LEAN_FRC_MSBs-REAL_FRC_MSBs) +
		((bigint)(exp + REAL_EXP_BIAS-LEAN_EXP_BIAS-1) << REAL_FRC_MSBs);
   }
#endif
   else rslt.r = ZERO;

   {bigint i; LEANasINT(i,x); if (i < 0) rslt.u.msh |= MINUS;}

   return rslt.r;
#else
   #error "GROWF not yet implemented for this size LEAN/REAL"
#endif
#endif
} /* GROWF */
#endif
