device-akna
===========

Provides the source code for `device-akna` and related packages:

* device-akna-base - the "base" system
* device-akna - the full system (mostly metapackage)
* emmc-installer-akna - eMMC installer frontend
* mkos-akna-native - mkos native-only frontend
* bootloader-image-akna - metapackage that specifies the bootloader
* linux-image-akna - metapackage that specifies the Linux kernel

Build Instructions
------------------

```bash
  user@workstation:~$ cd device-akna
  user@workstation:~$ git clean -dxf
  user@workstation:~$ ptuxbuild
```

The build products will be placed into `debian/build/`.

device-akna-base
================

This binary package defines the "base" system, including:
* hostname
* ethernet interface configurations
* the `update-bootscr` script
* template u-boot boot script

When used as the anchoring package during bootstrapping, `device-akna-base`
will produce a console-only operating system image. This image is considerably
smaller than the `device-akna` image, and is easier to work with when graphics
aren't required.


device-akna
===========

This binary package produces the full Akna system:
* the contents of `device-akna-base`
* Qt runtime libraries
* X-server and **xorg.conf**

The `device-akna` package is the default dependency anchor for `mkos-akna`.

This binary package is intended to be used Akna devices to manage
their configurations, and by the Akna SDK for composing filesystem
images. See the `sdk-akna` README and/or the `mkos-akna(1)` manpage
for details regarding the latter.


emmc-installer-akna
===================

This binary package invokes `mkos-mlo-native` to compose a filesystem in eMMC
storage. The composition is supplied from a local package repository installed
by `mkos-mlo-foreign` for that purpose.

**This package is intended to be used by SD-based, automatic filesystem
installers only.** It cannot be hosted on an eMMC filesystem, and it can be
used manually only with extreme care.

## Theory of Operation

The `emmc-installer-akna` package contains `emmc-installer-akna.service`, which
launches the `mkos-akna` script once the system reaches
*multi-user.target*.

The `mkos-akna` script composes a filesystem in **/dev/mmcblk1p1** in the usual
way, relying on the init-hooks in `mkos-mlo-native` to partition, format, and
mount the device. The system is then halted, both to provide visual indication
that the operation is complete, and also to deter users of an "installer image"
from accidentally deploying a system running from it.

(Protip: To revert an "installer image" into an ordinary SD filesystem, simply
purge the `emmc-installer-akna` package at the device's command line. Or you
can `systemctl disable emmc-installer-akna` instead, if you want to make the
edit reversible.)

Note that the `mkos-akna` referred to here is NOT the same script that appears
in the SDK, although both versions build upon the logic found in
`mkos-mlo-common`. The script defined here works **only** with
mkos-mlo-native, and is therefore incompatible with the SDK's use case.

Note also that there will be no `mkos-akna` in the eMMC filesystem: the
emmc-installer-akna package appears on the SD image because the mstrap
configuration includes it by name in the multistrap configuration file. This is
intentional.

**NEVER LIST emmc-installer-akna in a *Depends:* unless you really, really know
what you are doing.** Otherwise, you'll risk your eMMC installation trying to
automatically reformat and reinstall itself at runtime.

There have been many, many iterations leading to the design decisions you see
in the `emmc-installer-akna` package's current form. In particular, we
intentionally use multistrap (via mkos-mlo-native) and a local reprepro package
repository, even though this approach requires more time and space than
possible alternatives. In exchange, we get guarantees that the resulting
filesystem's contents are generated repeatably and consistently, using the same
workflows that produce the target's SD filesystem. This decision greatly
enhances the reliablity and stability of the final work product, and is not to
be underestimated. This is a strategic decision, not a tactical one, and is
non-negotiable.

mkos-akna-native
================

Tailors `mkos-akna-native` for the Akna target, i.e. specifies the
`device-akna` package during filesystem composition. During package
installation, this script becomes an alias for `mkos-akna` via symlink.

NOTE: This script currently defaults to `device-akna` by design: we want to
avoid unintentionally auto-installing the device-akna-base package by
mistake. A side-effect of this decision is that the SDK's
`mkos-akna-base-installer` won't produce a self-installing device-akna-base
image.

To self-install device-akna-base to eMMC, use this command after the target
device boots into the SD image (after the device reboots to finalize the SD
image setup, if necessary):

```bash
root@device:~# device=akna-base mkos-akna
```

The modification required to eliminate this step is straightforward, and is
left as an exercise to the reader so that we're sure they understand what
they're doing. :-)


bootloader-image-akna
=====================

Placeholder metapackage, for specifying an exact bootloader package version
when a diversity of packages become visible to the SDK.

linux-image-akna
================

Disambiguates the linux image package to be used on the Akna target.
