# sdk-frontier

This source package defines the software development kit (SDK) for frontier targets.

## sdk-frontier

The `sdk-frontier` metapackage lists all of the workstation tools required
to build applications for frontier targets. This list is carefully
maintained, so that it is compatible with all recent `device-frontier`
binary package versions.

**At present, only Debian Buster workstation environments are
supported. Virtual machines and chroots are known to work, in
addition to native installations.**

### Installation

Add the location of the frontier SDK package repository to your
workstation's APT `sources.list.d` list. In most cases, this is
accomplished by installing the `apt-source-frontier-sdk` package provided
by your development team leader.

Next, add **armhf** to your workstation package manager's supported
architectures. This will allow your workstation's package manager to
install cross-platform development libraries:

```bash
user@workstation:~$ sudo dpkg --add-architecture armhf
user@workstation:~$ sudo apt update
```

Finally, install the `sdk-frontier` package:

```bash
user@workstation:~$ sudo apt install sdk-frontier
```

The result is a workstation with development tools required for
building frontier applications, and for composing filesystem images.


## mkos-frontier

The `mkos-frontier` package contains tools for composing SD filesystem images for frontier:

* `mkos-frontier-base` - "base" filesystem, i.e. console-only
* `mkos-frontier-base-installer` - "base" filesystem plus eMMC self-installer
* `mkos-frontier` - full filesystem, including GUI
* `mkos-frontier-installer` - full filesystem plus eMMC self-installer

The `mkos-frontier` package is included in the frontier SDK.

The eMMC self-installers transfer the SD image into frontier's onboard
eMMC storage device, then shut down the system (to provide visual
indication that the operation is complete). The system can then be
restarted without an SD card installed.

### Creating filesystem images

Choose one of the `mkos-frontier*` scripts depending on your
objective. All four scripts work in the same way, without additional
parameters, i.e.:

```bash
user@workstation:~$ mkos-frontier-base-installer
```

The output of interest is the SD image file, which ends in **.img**:

```bash
user@workstation:~$ ls
mkos-frontier.fs   mkos-frontier.iso       mkos-frontier.mstrap
mkos-frontier.img  mkos-frontier.manifest  mkos-frontier.repo
```

Note: The `mkos-frontier*` scripts require that that the hostname
**globalcooling** be resolveable.

### Writing filesystem images to SD

A command like the following will write an image file to an SD card:

```bash
user@workstation:~$ sudo dd if=mkos-frontier.img of=/dev/sdQ bs=1M conv=fsync
```

Note: Replace **/dev/sdQ** with your SD card's block device name.

### Adjusting mkos's behavior

The `mkos-frontier*` tools all use `multistrap(1)` to compose the
filesystem. The multistrap configuration file is stored under
`/usr/share/mkos-frontier`, and is also written to the working directory
when composition is performed.

To change `mkos-frontier`'s behavior, rename and then edit the **.mstrap**
file in your working directory, and then feed it to `mkos-frontier*`
instead of the default:

```bash
user@workstation:$ CFG=my-config.mstrap mkos-frontier-base-installer
```

