// Simple logging-style output facility.
#include <iostream>
#include <sstream>
#include <string>

typedef enum { FATAL, ERROR, WARN, INFO, DEBUG, TRACE } log_t;
extern log_t log_level;

static void fatal(const std::string& s) { std::cout << "F: " << s << std::endl; }
static void fatal(std::stringstream& os) { fatal(os.str()); };
static void error(const std::string& s) { if (log_level >= ERROR) std::cout << "E: " << s << std::endl; }
static void error(std::stringstream& os) { error(os.str()); }
static void warn(const std::string& s) { if (log_level >= WARN) std::cout << "W: " << s << std::endl; }
static void warn(std::stringstream& os) { warn(os.str()); }
static void info(const std::string& s) { if (log_level >= INFO) std::cout << "I: " << s << std::endl; }
static void info(std::stringstream& os) { info(os.str()); }
static void debug(const std::string& s) { if (log_level >= DEBUG) std::cout << "D: " << s << std::endl; }
static void debug(std::stringstream& os) { debug(os.str()); }
static void trace(const std::string& s) { if (log_level >= TRACE) std::cout << "T: " << s << std::endl; }
static void trace(std::stringstream& os) { trace(os.str()); }
