//

#if !defined(INFLUXDB_INCLUDED)
#define INFLUXDB_INCLUDED
#include <curl/curl.h>

class influxdb
{
public:
       influxdb();
       ~influxdb();

       influxdb(const std::string& _host,
                const std::string& _db,
                const std::string& _precision);

       void send(const std::stringstream& ss);
       void send(const std::string& s);

       void set_host(const std::string& _host) { host = _host; }
       void set_database(const std::string& _db) { db = _db; }
       void set_precision(const std::string& _precision) { precision = _precision; }

private:
       std::string host{"localhost:8086"};
       std::string db{"mydb"};
       std::string precision{"ms"};

       std::string buf;
       std::mutex m;
       CURL* curl{NULL};
       size_t send_callback(char* ptr, size_t size, size_t nmemb);
       static size_t curl_callback(char *ptr, size_t size, size_t nmemb, void *data);
};
#endif
