#include <signal.h>

#include <iostream>
#include <sstream>
#include <fstream>
#include <regex>
#include <string>
#include <mutex>
#include <time.h>

#include <curl/curl.h>

#include "influxdb.h"
#include "log.h"

#include <sys/types.h>
#include <unistd.h>

influxdb::influxdb()
{
       curl_global_init(CURL_GLOBAL_DEFAULT);
       curl = curl_easy_init();
}

influxdb::influxdb(const std::string& _host,
                   const std::string& _db,
                   const std::string& _precision) :
       host(_host), db(_db), precision(_precision)
{
}

influxdb::~influxdb()
{
       curl_easy_cleanup(curl);
}

// Called by cURL when it wants data to post.
size_t influxdb::curl_callback(char *ptr, size_t size, size_t nmemb, void *data)
{
       influxdb* db = (influxdb*)data;
       return db->send_callback(ptr, size, nmemb);
}

size_t influxdb::send_callback(char* ptr, size_t size, size_t nmemb)
{
       size_t ret = 0;

       {
              std::scoped_lock l(m);
              // TODO: curl_easy_escape()
              ret = buf.length();
              if (ret > size * nmemb)
                     ret = size * nmemb;
              memcpy(ptr, buf.c_str(), ret);
              buf.erase(0, ret);
       }
       return ret;
}

void influxdb::send(const std::stringstream& ss) { send(ss.str()); }

void influxdb::send(const std::string& line)
{
       {
              // Append the line to our line buffer.
              std::scoped_lock l(m);
              buf += line;
              buf += "\n";
       }

       // Create the URL.
       std::stringstream ss;
       ss << "http://" << host;
       ss << "/write?";
       ss << "db=" << db;
       ss << "&precision=" << precision;
       trace(ss);

       // Set libcURL options.
       CURLcode ret;
       // curl_easy_setopt(curl, CURLOPT_VERBOSE, 1L);
       curl_easy_setopt(curl, CURLOPT_URL, ss.str().c_str());

       struct curl_slist *slist = NULL;
       slist = curl_slist_append(slist, "Content-Type: text/plain; charset=utf-8");
       slist = curl_slist_append(slist, "Accept: application/json");
       slist = curl_slist_append(slist, "Transfer-Encoding: chunked");
       curl_easy_setopt(curl, CURLOPT_HTTPHEADER, slist);

       curl_easy_setopt(curl, CURLOPT_POST, 1L);
       curl_easy_setopt(curl, CURLOPT_POSTFIELDS, NULL);
       curl_easy_setopt(curl, CURLOPT_READFUNCTION, curl_callback);
       curl_easy_setopt(curl, CURLOPT_READDATA, (void *)this);

       // Run the post.
       ret = curl_easy_perform(curl);
       curl_slist_free_all(slist);
}
