# frontier-updaterd

Services and scripts to implement frontier's package update mechanisms.

## Theory of Operation

The `frontier-updaterd.service` unit runs whenever the contents of `/media/usb[01]`
and/or `/var/www/frontier/update` are changed, i.e. when an updater image or
package file becomes accessible.

A *package file* is an ordinary Debian `.deb` file. An *updater image* is an
ISO9660 image file containing an APT repository.

The `frontier-updater` script examines the incoming file, and passes it one of the
following helpers based on the file type:
* `frontier-updater-helper`, for deb files;
* `frontier-updater-apthelper`, for ISO9660 images.

The `frontier-updater-helper` script installs the deb using `dpkg`, running
inside of a transient systemd service. We use `systemd-run` so that the helper
script itself can be subject to an ordinary package upgrade.

The `frontier-updater-apthelper` script runs `apt dist-upgrade -y` inside of a
transient systemd service.

After the helper script exits, the associated file is deleted. Unrecognized
file types are deleted without further action.

## Build Instructions

```console
user@workstation:~/frontier-updater$ git clean -dxf
user@workstation:~/frontier-updater$ ptuxbuild
```

The build products are placed in `debian/build/`.



