device-frontier
===========

Provides the source code for `device-frontier` and related packages:

* device-frontier-base - the "base" system
* device-frontier - the full system (mostly metapackage)
* emmc-installer-frontier - eMMC installer frontend
* mkos-frontier-native - mkos native-only frontend
* bootloader-image-frontier - metapackage that specifies the bootloader
* linux-image-frontier - metapackage that specifies the Linux kernel

Build Instructions
------------------

```bash
  user@workstation:~$ cd device-frontier
  user@workstation:~$ git clean -dxf
  user@workstation:~$ ptuxbuild
```

The build products will be placed into `debian/build/`.

device-frontier-base
================

This binary package defines the "base" system, including:
* hostname
* ethernet interface configurations
* the `update-bootscr` script
* template u-boot boot script

When used as the anchoring package during bootstrapping, `device-frontier-base`
will produce a console-only operating system image. This image is considerably
smaller than the `device-frontier` image, and is easier to work with when graphics
aren't required.


device-frontier
===========

This binary package produces the full frontier system:
* the contents of `device-frontier-base`
* Qt runtime libraries
* X-server and **xorg.conf**

The `device-frontier` package is the default dependency anchor for `mkos-frontier`.

This binary package is intended to be used frontier devices to manage
their configurations, and by the frontier SDK for composing filesystem
images. See the `sdk-frontier` README and/or the `mkos-frontier(1)` manpage
for details regarding the latter.


emmc-installer-frontier
===================

This binary package invokes `mkos-mlo-native` to compose a filesystem in eMMC
storage. The composition is supplied from a local package repository installed
by `mkos-mlo-foreign` for that purpose.

**This package is intended to be used by SD-based, automatic filesystem
installers only.** It cannot be hosted on an eMMC filesystem, and it can be
used manually only with extreme care.

## Theory of Operation

The `emmc-installer-frontier` package contains `emmc-installer-frontier.service`, which
launches the `mkos-frontier` script once the system reaches
*multi-user.target*.

The `mkos-frontier` script composes a filesystem in **/dev/mmcblk1p1** in the usual
way, relying on the init-hooks in `mkos-mlo-native` to partition, format, and
mount the device. The system is then halted, both to provide visual indication
that the operation is complete, and also to deter users of an "installer image"
from accidentally deploying a system running from it.

(Protip: To revert an "installer image" into an ordinary SD filesystem, simply
purge the `emmc-installer-frontier` package at the device's command line. Or you
can `systemctl disable emmc-installer-frontier` instead, if you want to make the
edit reversible.)

Note that the `mkos-frontier` referred to here is NOT the same script that appears
in the SDK, although both versions build upon the logic found in
`mkos-mlo-common`. The script defined here works **only** with
mkos-mlo-native, and is therefore incompatible with the SDK's use case.

Note also that there will be no `mkos-frontier` in the eMMC filesystem: the
emmc-installer-frontier package appears on the SD image because the mstrap
configuration includes it by name in the multistrap configuration file. This is
intentional.

**NEVER LIST emmc-installer-frontier in a *Depends:* unless you really, really know
what you are doing.** Otherwise, you'll risk your eMMC installation trying to
automatically reformat and reinstall itself at runtime.

There have been many, many iterations leading to the design decisions you see
in the `emmc-installer-frontier` package's current form. In particular, we
intentionally use multistrap (via mkos-mlo-native) and a local reprepro package
repository, even though this approach requires more time and space than
possible alternatives. In exchange, we get guarantees that the resulting
filesystem's contents are generated repeatably and consistently, using the same
workflows that produce the target's SD filesystem. This decision greatly
enhances the reliablity and stability of the final work product, and is not to
be underestimated. This is a strategic decision, not a tactical one, and is
non-negotiable.

mkos-frontier-native
================

Tailors `mkos-frontier-native` for the frontier target, i.e. specifies the
`device-frontier` package during filesystem composition. During package
installation, this script becomes an alias for `mkos-frontier` via symlink.

NOTE: This script currently defaults to `device-frontier` by design: we want to
avoid unintentionally auto-installing the device-frontier-base package by
mistake. A side-effect of this decision is that the SDK's
`mkos-frontier-base-installer` won't produce a self-installing device-frontier-base
image.

To self-install device-frontier-base to eMMC, use this command after the target
device boots into the SD image (after the device reboots to finalize the SD
image setup, if necessary):

```bash
root@device:~# device=frontier-base mkos-frontier
```

The modification required to eliminate this step is straightforward, and is
left as an exercise to the reader so that we're sure they understand what
they're doing. :-)


bootloader-image-frontier
=====================

Placeholder metapackage, for specifying an exact bootloader package version
when a diversity of packages become visible to the SDK.

linux-image-frontier
================

Disambiguates the linux image package to be used on the frontier target.
