# system-updater

Services and scripts to implement a generic system-update mechanism.

## Theory of Operation

The `system-updater` service is launched whenever update materials are
delivered to the host system. "Update materials" include individual package
files, or an entire package repository. The system-updater service examines the
update materials, and forwards them to the appropriate helper script based on
type. The helper script performs the update.

The `system-updater` service does not know the circumstances under which an
update is permissible, its job is simply to run the update procedure when
requested. Ways to request an update might include a package file appearing in
a well-known path in the filesystem, or by plugging in a USB storage device
containing an ISO-formatted APT repository.

We accommodate USB storage devices using an interface compatible with
`usbmount`, i.e. an environment variable **DEVNAME** indicates the block device
where the filesystem containing the update materials is located. We require
that the block device is already mounted, and we use `lsblk` to identify the
mount point.

If DEVNAME is not defined, we require a single command-line option containing
the path to the directory where the update materials are located. That
directory may contain one or more package files, and/or one or more APT
repositories stored in ISO-formatted filesystem image files.

Once we've identified the location and type of the update materials, the
request is forwarded to the correct "helper" based on file type:
* `system-updater-debhelper`, for deb files;
* `system-updater-apthelper`, for ISO9660 images.

The `system-updater-debhelper` script installs the deb using `dpkg`, running
inside of a transient systemd service unit. We use `systemd-run` so that the
helper script itself can be subject to an ordinary package upgrade.

The `system-updater-apthelper` script runs `apt dist-upgrade -y` inside of a
transient systemd service.

Unrecognized file types are ignored.


## system-updater-usbmount

The `system-updater-usbmount` package installs a usbmount override that
launches `system-updater` when a USB storage device is inserted.

Note: We do not indicate when the update activity is complete, nor do we
unmount the USB device when we're done. If you need those sorts of things, add
an override of your own using `50_system-updater.conf` as an example.

## system-updater-www

The `system-updater-www` package installs a systemd path service that listens
for files arriving in `/var/www/update/`.


## Build Instructions

```console
user@workstation:~/akna-updater$ git clean -dxf
user@workstation:~/akna-updater$ ptuxbuild
```

The build products are placed in `debian/build/`.



