# Updating an Akna System

Akna systems support "updates" via the usual, Debian-based
mechanisms: APT, and DPKG. Akna provides some additional
functions around those mechanisms, to be used as-is or as a starting
point for a more customized approach.

**Note:** Akna's system update mechanisms rely on initiation by
the system's operator. Due to the customer-specific complexities and
security interests involved, Akna provides support for unattended
system updates on a request basis only.

**Note:** The default Akna configuration supports unsigned
packages only. The steps required to support signed packages is
beyond the scope of this document.

## Single-Package Updates from the Command Line

Akna supports manually-invoked package updates initiated from the
command line.  Once the package file itself is copied to the target's
filesystem, a command like the following will work:

``
root@device:~$ sudo dpkg --install <package>.deb
``

This approach is suitable for updating a small number of packages
during development, or for interactively troubleshooting a deployed
device.


## Remote Single-Package Updates

If the `system-updater-www` feature is installed, then individual
packages can be transferred to the target device using `cURL`, or a
similar tool. When the file arrives in the target's `/var/www/update/`
directory, the target system will invoke `dpkg` to install the
package.

For example, to copy a package file using cURL:

``
user@workstation:~$ curl -T <package>.deb http://<ip>/update/
``

Note: The system-updater-www feature requires a configured web server.

Note: Using SSH as the transport mechanism for system-updater-www is
not recommended. SSH streams files directly to their destination
location, which can cause system-updater-www to initiate before the
file transfer is complete. Tools like cURL download the file to /tmp/
first, and then move the file to the destination after the transfer is
complete.

## Local Single-Package Updates via USB

When a USB device is mounted via usbmount, the
`system-updater-usbmount` feature will attempt to install any files
located in the root directory of the device's filesystem, if those
files appear to be Debian package files.

This mechanism is useful for updating only one or two packages, in
cases where no inter-package dependencies are an issue. When multiple
package files are found on the storage device, the updater installs
them in lexical order according to filename.

Note: The updater uses file(1) to identify package files, so package
file names do not need a *.deb extension.


## Multi-Package Updates via USB or Remote File Transfer

When the system-updater facility receives an ISO image file containing
an APT package repository (instead of a single package file as
previously described), that repository is used as the package source
for an `apt upgrade` operation. This is the recommended approach for
system-wide upgrades, since inter-package dependencies will be
resolved correctly during the update procedure itself.

The ISO file produced by mkos includes an APT repository containing
all of the package files used by the image. This file is intended to
be used for system-wide upgrades via `system-updater`.


## Theory of Operation: Updates via USB

The `usbmount` utility invokes all scripts located in
`/etc/usbmount/mount.d/` whenever a USB device is mounted. Similarly,
`systemd` will launch services defined in
`/etc/systemd/system/usbmount@.service.d/` whenever the usbmount
service is run. The system-updater-usbmount feature uses the latter
approach to launch the core `system-updater` service.

See the README in the system-updater source package for more details.

## Theory of Operation: Updates via File Transfer

The `system-installer-www.path` systemd unit monitors
`/var/www/update/` for incoming files. When a file appears, the core
`system-updater` service is launched.

See the README in the system-updater source package for more details.


## Helpful Troubleshooting Command

``
root@device:~$ sudo journalctl -fu usbmount@dev-sda1 -fu system-updater -fu system-updater-usbmount
``